<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateScheduledDeliveryTimeListsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('scheduled_delivery_time_lists')){
            Schema::create('scheduled_delivery_time_lists', function (Blueprint $table) {
                $table->id();
                $table->text('timeline');
                $table->integer('sorting_order')->default(0);
                $table->timestamps();
                $table->softDeletes();
            });
        } 
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('scheduled_delivery_time_lists');
    }
}
