<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRewardPointsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('reward_points')){
            Schema::create('reward_points', function (Blueprint $table) {
                $table->id();
                $table->integer('user_id');
                $table->bigInteger('order_group_id');
                $table->bigInteger('total_points')->default(0);
                $table->tinyInteger('is_converted')->default(0);
                $table->string('status')->nullable();
                $table->timestamps();
            });
        }   
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reward_points');
    }
}
