<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWalletHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('wallet_histories')){
            Schema::create('wallet_histories', function (Blueprint $table) {
                $table->id();
                $table->integer('user_id');
                $table->double('amount')->default('0.00');
                $table->string('payment_method')->nullable();
                $table->string('status')->default('added')->comment('added/pending/cancelled');
                $table->timestamps();
            });
        }  
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('wallet_histories');
    }
}
